$(document).ready(function(){

    // INCLUDES
    $(".nav-background").load('include/menu_principal.html');
    $("#btn-subir").load('include/subir.html');
    $("#footer").load('include/footer.html');

});




function esEntero(numero) {
  return (parseFloat(numero) % 1 === 0) ? 1 : 2;
}

$('.cantidad').each(function () {
  var $this = $(this);
  var numero = esEntero($this.text());

  jQuery({ Counter: 0 }).animate({ Counter: parseFloat($this.text()) }, {
    duration: 1000,
    easing: 'swing',
    step: function (now) {
      if (numero === 2) {
        var num = Math.round(now * 1000) / 1000;
        $this.text(num); 
      } else {
        var num = Math.round(now);
        $this.text(num);
      }
    },
    complete: function () {
      $('.cantidad').each(function () {
        var $this = $(this);
        var valor = parseFloat($this.text());

        if (isNaN(valor)) return;

        switch ($this.text()) {
          case "5178.35": $this.text("5,178,350"); return;
          case "78.62": $this.text("78,620"); return;
          case "5.57": $this.text("5,570"); return;
          case "1.3": $this.text("1,300"); return;
          case "1.97": $this.text("1,970"); return;
          case "1.91": $this.text("1,910"); return;
          case "152": $this.text("152,000"); return;
          case "65": $this.text("65,000"); return;
          case "2": $this.text("2,000"); return;
          case "10": $this.text("10,000"); return;
          case "3.5": $this.text("3,500"); return;
          case "2.96": $this.text("2,960,000"); return;
          case "5.000": $this.text("5,000"); return;
          case "10.00": $this.text("10,000"); return;
          case "15.1": $this.text("15.10"); return; 
        }

      
        if (valor % 1 === 0) {
          $this.text(valor.toLocaleString('en-US', {
            minimumFractionDigits: 0,
            maximumFractionDigits: 0
          }));
        } else {
          $this.text(valor.toLocaleString('en-US', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
          }));
        }
      });
    }
  });
});


 $('.cantidadcustom').each(function () {
    var $this = $(this);
    jQuery({ Counter: 0 }).animate({ Counter: $this.text() }, {
        duration: 1000,
        easing: 'swing',
        step: function (now) {
            var num = Math.round(now * 100000000) / 100000000;
            var raw = num.toString();

            var exceptions = ["2.9", "69.6", "1.74"];
            if (!exceptions.includes(raw)) {
                raw = raw.replace(".", ",");
            }

            $this.text(raw);
        },
        complete: function (now) {
            $('.cantidadcustom').each(function () {
                var $this = $(this);
                var val = $this.text();

         
                if(val == "5,685266"){
                    $this.text("5,685,266"); 
                } else if(val == "6,18"){            
                    $this.text("6,180"); 
                } else if(val == "4,32075775"){            
                    $this.text("4,320,757.75"); 
                } else if(val == "4,16476175"){            
                    $this.text("4,164,761.75"); 
                } else if(val == "684,133416"){            
                    $this.text("684,133,416"); 
                } else if(val == "1,814"){            
                    $this.text("1,814,000"); 
                } else if(val == "1,457678"){            
                    $this.text("1,457,678"); 
                } else if(val == "3,43872892"){            
                    $this.text("3,438,728.92"); 
                } else if(val == "3,55270474"){
                    $this.text("3,552,704.74");
                } else if(val == "7,437812"){
                    $this.text("7,437,812");
                } else if(val == "3,59274262"){
                    $this.text("3,592,742.62");
                } else if(val == "8,492526"){
                    $this.text("8,492,526");
                } else if(val == "9,076633"){
                    $this.text("9,076,633");
                } else if(val == "8,437025"){ 
                    $this.text("8,437,025");
                } else if(val == "7,77"){
                    $this.text("7,770");  
                } else if(val == "10"){
                    $this.text("10,000");
                } else if(val == "1,55"){
                    $this.text("1,550");
                } else if(val == "2"){
                    $this.text("2,000");
                } else if(val == "25,306"){
                    $this.text("25,306");
                }
            });
        }
    });
});

/* $('.cantidadcustom').each(function () {
  var $this = $(this);
  var valorNumerico = parseInt($this.data('valor'));
  var total = parseInt($this.data('total'));
  var pasos = parseInt($this.data('pasos'));

  jQuery({ Counter: 0 }).animate({ Counter: valorNumerico }, {
    duration: 1000,
    easing: 'swing',
    step: function (now) {
      var num = Math.floor(now).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
      $this.text(num);

      // porcentaje
      var porcentaje = Math.floor((now / total) * 100);
      $this.closest('.bloque').find('.porcentaje').text(porcentaje + "%");

      // contador tipo 1 / N
      var actualPaso = Math.ceil((now / total) * pasos);
      if (actualPaso > pasos) actualPaso = pasos;
      $this.closest('.bloque').find('.contador').text(actualPaso + " / " + pasos);
    }
  });
}); */
